from django.shortcuts import render
from .utils import generate_random_palette

def home(request):
    count = 5
    try:
        # allow query param to set count, limited to 12
        q = int(request.GET.get('count', '5'))
        if 1 <= q <= 12:
            count = q
    except Exception:
        count = 5

    palette = generate_random_palette(count)
    return render(request, 'index.html', {'palette': palette, 'count': count})
